<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Home - Excellence EXIM</title>
    <!-- favicons Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="assets/images/favicons/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/images/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/images/favicons/favicon-16x16.png">
    <link rel="manifest" href="assets/images/favicons/site.webmanifest">
    <?php include 'include/head.php' ?>
</head>

<body class="custom-cursor">

    <div class="custom-cursor__cursor"></div>
    <div class="custom-cursor__cursor-two"></div>

    <div class="preloader">
        <div class="preloader__image" style="background-image: url(assets/images/loader.png);"></div>
    </div>
    <!-- /.preloader -->
    <div class="page-wrapper">
        <!--?php include 'include/top.php' ?--> 

        <?php include 'include/header.php' ?>
        <!-- /.main-header -->
        <!-- main-slider-start -->
        <section class="main-slider-one" id="index">
            <div class="main-slider-one__carousel agrofa-owl__carousel owl-carousel" data-owl-options='{
		"loop": false,
		"animateOut": "fadeOut",
		"animateIn": "fadeIn",
		"items": 1,
		"autoplay": false,
		"autoplayTimeout": 7000,
		"smartSpeed": 1000,
		"nav": false,
        "navText": ["<span class=\"icon-left-arrow1\"></span>","<span class=\"icon-right-arrow1\"></span>"],
		"dots": false,
		"margin": 0
		}'>
                <div class="item">
                    <div class="main-slider-one__item">
                        <div class="main-slider-one__bg" style="background-image: url('assets/images/hero-images/hero-img1-2.jpg')"></div>
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <div class="main-slider-one__content">
                                        <div class="main-slider-one__sub-title-bx">
                                            <img class="main-slider-one__tree-icon" src="assets/images/shapes/hero-tree-icon1-1.png" alt="agrofa" />
                                            <h5 class="main-slider-one__sub-title">Organic & Eco Solutions</h5>
                                        </div>
                                        <!-- slider-sub-title -->
                                        <h1 class="main-slider-one__title">Your Finest Option for Healthy Food</h1><!-- slider-title -->
                                        <p class="main-slider-one__info-text">At Excellence EXIM, we believe that excellence is not just in our name<br /> it's in everything we do. Founded in March 2023 </p>
                                        <div class="main-slider-one__btn">
                                            <a href="#" class="agrofa-btn agrofa-btn--base"><span>Our Services</span></a><!-- slider-btn -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="main-slider-one__line-bx">
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                        </div>
                    </div>
                </div>

                <div class="item d-none">
                    <div class="main-slider-one__item">
                        <div class="main-slider-one__bg" style="background-image: url('assets/images/hero-images/hero-img1-2.jpg');"></div>
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <div class="main-slider-one__content">
                                        <div class="main-slider-one__sub-title-bx">
                                            <img class="main-slider-one__tree-icon" src="assets/images/shapes/hero-tree-icon1-1.png" alt="agrofa" />
                                            <h5 class="main-slider-one__sub-title">Organic & Eco Solutions</h5>
                                        </div>
                                        <!-- slider-sub-title -->
                                        <h1 class="main-slider-one__title">Your Finest Option for Healthy Food</h1><!-- slider-title -->
                                        <p class="main-slider-one__info-text">From climate emergency to food security, the way we farm is key <br /> to solving some of the biggest issues facing us today.</p>
                                        <div class="main-slider-one__btn">
                                            <a href="#" class="agrofa-btn agrofa-btn--base"><span>Our Services</span></a><!-- slider-btn -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="main-slider-one__line-bx">
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                        </div>
                    </div>
                </div>
                <div class="item d-none">
                    <div class="main-slider-one__item">
                        <div class="main-slider-one__bg" style="background-image: url('assets/images/hero-images/hero-img1-3.jpg');"></div>
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <div class="main-slider-one__content">
                                        <div class="main-slider-one__sub-title-bx">
                                            <img class="main-slider-one__tree-icon" src="assets/images/shapes/hero-tree-icon1-1.png" alt="agrofa" />
                                            <h5 class="main-slider-one__sub-title">Organic & Eco Solutions</h5>
                                        </div>
                                        <!-- slider-sub-title -->
                                        <h1 class="main-slider-one__title">Your Finest Option for Healthy Food</h1><!-- slider-title -->
                                        <p class="main-slider-one__info-text">From climate emergency to food security, the way we farm is key <br /> to solving some of the biggest issues facing us today.</p>
                                        <div class="main-slider-one__btn">
                                            <a href="#" class="agrofa-btn agrofa-btn--base"><span>Our Services</span></a><!-- slider-btn -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="main-slider-one__line-bx">
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                            <span class="main-slider-one__line"></span>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- main-slider-end -->

        <!-- Feature Start -->
        <section class="feature-one">
            <div class="container">
                <div class="row">
                    <div class="feature-one__col-item col-md-4 col-sm-12 wow fadeInUp" data-wow-delay="100ms">
                        <div class="feature-one__item text-center">
                            <div class="feature-one__item-bg">
                                <div class="feature-one__cricle-icon">
                                    <i class="icon-apple feature-one__icon" aria-hidden="true"></i>
                                </div>
                                <h3 class="feature-one__title">Quality Organic <br> Food Store</h3>
                            </div>
                        </div><!-- feature-item -->
                    </div>

                    <div class="feature-one__col-item col-md-4 col-sm-12 wow fadeInUp" data-wow-delay="100ms">
                        <div class="feature-one__item text-center">
                            <div class="feature-one__item-bg">
                                <div class="feature-one__cricle-icon">
                                    <i class="icon-hand feature-one__icon" aria-hidden="true"></i>
                                </div>
                                <h3 class="feature-one__title">Quality Standards <br> Services</h3>
                            </div>
                        </div><!-- feature-item -->
                    </div>

                    <div class="feature-one__col-item col-md-4 col-sm-12 wow fadeInUp" data-wow-delay="100ms">
                        <div class="feature-one__item text-center">
                            <div class="feature-one__item-bg">
                                <div class="feature-one__cricle-icon">
                                    <i class="icon-tractor feature-one__icon" aria-hidden="true"></i>
                                </div>
                                <h3 class="feature-one__title">Organic Food Straight <br> From The Farmer</h3>
                            </div>
                        </div><!-- feature-item -->
                    </div>
                </div>
            </div>
        </section>
        <!-- Feature End -->
        <section class="about-two" id="about">
            <div class="container-fluid">
                <div class="row about-two__content-row">
                    <div class="about-two__left fadeInLeft wow" data-wow-delay="1500ms">
                        <div class="about-two__left__all-product">
                            <div class="about-two__left__bg text-center">
                                <h4 class="about-two__left__count-product">100%</h4>
                                <h5 class="about-two__left__pure-product"> Satisfaction
                                    guarantee</h5>
                            </div>
                        </div>
                    </div>

                    <div class="about-two__right fadeInRight wow align-self-center" data-wow-delay="1500ms">
                        <div class="section-common-title">
                            <span class="about-two__chose-reasone food-chose-reasone">
                                <img class="about-two__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                <strong class="about-two__chose-name food-chose-name">About our Compnay</strong>
                            </span>
                            <!--<h2 class="about-two__title food-chose-title">Providing the Organic service </h2>-->
                            <p class="about-two__text food-chose-text">At Excellence EXIM, we believe that excellence is not just in our name — it's in everything we do. 
                            Founded in March 2023 by the husband-wife duo Mr. Umesh Birole and Mrs. Rupali Birole, our company was born from a shared vision: 
                            to bring the rich, authentic, and organic agricultural produce of India to the global market. With a primary focus on organic turmeric, 
                            we aim to redefine the standards of purity, quality, and sustainability in global spice trade.</p>
                            <p class="about-two__text food-chose-text">We are a family-run business rooted in values of integrity, trust, and long-term relationships. 
                            What sets us apart is not just what we export, but how we do it — with full control over the quality and cultivation practices of our 
                            flagship product: organic turmeric grown and processed at our very own farm, located just 70 kilometers from Nagpur, Maharashtra. 
                            Every batch that leaves our facility carries with it a story of care, tradition, and science-backed agriculture.</p>
                        </div>
                        <div class="why-choose-one__more-choose--btn">
                            <a href="about.php" class="agrofa-btn why-choose-more--btn"><span>Read More</span></a>
                        </div>
                        <div class="about-two__featurebx d-none">
                            <div class="about-two__col">
                                <div class="about-two__cricle">
                                    <i class="icon-medal about-two__icon" aria-hidden="true"></i>
                                </div>
                                <div class="about-two__quality-info-bx">
                                    <h6 class="about-two__quality-title">100% Guaranteed Organic</h6>
                                    <p class="about-two__quality-info">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore </p>
                                </div>
                            </div>
                            <div class="about-two__col">
                                <div class="about-two__cricle">
                                    <i class="icon-crops about-two__icon" aria-hidden="true"></i>
                                </div>
                                <div class="about-two__quality-info-bx">
                                    <h6 class="about-two__quality-title">Top-Quality Healthy Foods</h6>
                                    <p class="about-two__quality-info">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore </p>
                                </div>
                            </div>
                        </div>
                        
                        <ul class="about-two__quality-list d-none">
                            <li><i class="fas fa-check-circle"></i> Need help converting to organic or farming more sustainably?</li>
                            <li><i class="fas fa-check-circle"></i> Fresh, reliable, sustainable ingredients for the food industry</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="about-two__effect-bg">
                <img src="assets/images/resources/about-photo2-1.png" alt="">
            </div>
        </section>
        
        
        <section class="food-one d-none" id="origins">
            <div class="container">
                <div class="row food-one__content-bx">
                    <div class="food-one__left fadeInLeft wow align-self-center" data-wow-delay="200ms">
                        <div class="section-common-title">
                            <span class="food-one__chose-reasone food-chose-reasone">
                                <img class="food-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                <strong class="food-one__chose-name food-chose-name">Our Origins</strong>
                            </span>
                            <!--<h2 class="food-one__title food-chose-title">Get Food Without Preservatives.</h2>-->
                            <p class="food-one__text food-chose-text">Excellence EXIM was established with a simple yet powerful purpose: 
                            to make India’s organic produce more accessible to international markets while supporting sustainable farming and empowering 
                            rural communities. Coming from a background with a deep connection to the land, Mr.Umesh and Mrs.Rupali Birole understood early 
                            on the immense potential of organic farming — not just as a business model, but as a movement that contributes to healthier living, 
                            safer food chains, and a more balanced ecosystem.</p>
                            <p class="food-one__text food-chose-text">From the beginning, the goal was not volume, but value. Rather than becoming just another exporter, 
                            we chose to specialize in products we deeply understand, ensuring that every shipment carries our signature of transparency, 
                            traceability, and trust.</p>
                        </div>

                        <div class="food-one__featurebx d-none">
                            <div class="food-one__col">
                                <div class="food-one__cricle">
                                    <i class="icon-medal food-one__icon" aria-hidden="true"></i>
                                </div>
                                <div class="food-one__quality-info-bx">
                                    <h6 class="food-one__quality-title">100% Guaranteed Organic</h6>
                                    <p class="food-one__quality-info">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore </p>
                                </div>
                            </div>

                            <div class="food-one__col">
                                <div class="food-one__cricle">
                                    <i class="icon-crops food-one__icon" aria-hidden="true"></i>
                                </div>
                                <div class="food-one__quality-info-bx">
                                    <h6 class="food-one__quality-title">Top-Quality Healthy Foods</h6>
                                    <p class="food-one__quality-info">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="food-one__right fadeInRight wow" data-wow-delay="200ms">
                        <div class="food-one__right-img">
                            <img src="assets/images/resources/food-men1-1.png" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </section><!-- /.food-one -->
        
        <section class="food-one food-one--two d-none" id="what_we_do">
            <div class="container">
                <div class="row food-one__content-bx flex-row-reverse">
                    <div class="food-one__left fadeInRight wow animated align-self-center" data-wow-delay="300ms">
                        <div class="section-common-title">
                            <span class="food-one__chose-reasone food-chose-reasone">
                                <img class="food-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                <strong class="food-one__chose-name food-chose-name">What We Do</strong>
                            </span>
                            <!--<h2 class="food-one__title food-chose-title">Our Farm And Who We Are</h2>-->
                            <p class="food-one__text food-chose-text">At the heart of Excellence EXIM lies our organic turmeric, cultivated using natural and regenerative 
                            farming practices that restore soil health, avoid chemical inputs, and ensure maximum potency of curcumin — the active ingredient known for its 
                            medicinal and culinary benefits. Our farm near Nagpur enjoys ideal agro-climatic conditions for turmeric cultivation, and we manage every stage 
                            of the process — from sowing and harvesting to drying, grinding, and packaging.</p>
                            <p class="food-one__text food-chose-text">We are not limited to turmeric alone. As we grow, our portfolio of organic spices and agricultural products will expand to include other natural 
                            exports such as ginger, moong dal, and select pulses and grains — all sourced ethically from certified organic farms across India.</p>
                        </div>

                        <div class="food-one__feature--wrap d-flex flex-wrap d-none">
                            <div class="food-one__feature--wrap__col">
                                <div class="food-one__feature--wrap__bg yellow--bg">
                                    <i class="icon-medal"></i>
                                    <h6 class="food-one__feature--wrap__title">100% Guaranteed <br> Organic farm</h6>
                                </div>
                            </div>

                            <div class="food-one__feature--wrap__col">
                                <div class="food-one__feature--wrap__bg green--bg">
                                    <i class="icon-farmer"></i>
                                    <h6 class="food-one__feature--wrap__title">Professional <br> Farmers</h6>
                                </div>
                            </div>
                        </div>
                        <ul class="food-one__quality-list d-none">
                            <li><i class="icon-cda67021ce37b3d91d9f660e16bda341"></i> Adipisci velit sed quia non numquam eius modi tempora </li>
                            <li><i class="icon-cda67021ce37b3d91d9f660e16bda341"></i> Providing High Quality Products many variations of passages of lorem</li>
                        </ul>
                    </div>

                    <div class="food-one__right fadeInLeft wow animated" data-wow-delay="300ms">
                        <div class="food-one__right-img">
                            <img src="assets/images/resources/food-men3-1.png" alt="">
                        </div>
                        <div class="food-one__bottom-img">
                            <img src="assets/images/resources/food-men3-2.png" alt="">
                        </div>
                    </div>
                </div>
            </div>

            <div class="food-one--two__effect-left">
                <img src="assets/images/shapes/food-shape3-2.png" alt="">
            </div>
            <div class="food-one--two__effect-right">
                <img src="assets/images/shapes/food-shape3-1.png" alt="">
            </div>
        </section> <!-- /.food-one--two -->
        
        <section class="why-choose-one why-choose-one--three" id="philosophy">
            <div class="container">
                <div class="section-common-title fadeInDown wow" data-wow-delay="500ms">
                    <div class="section-additional-title-wrap">
                        <span class="why-choose-one__chose-reasone food-chose-reasone">
                            <img class="why-choose-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                            <strong class="why-choose-one__chose-name food-chose-name">Our Philosophy</strong>
                        </span>
                        <!--<h2 class="why-choose-one__title food-chose-title">Our Philosophy</h2>-->
                        <p class="food-one__text food-chose-text">We are driven by the belief that organic is the future — not just for consumers, but for farmers
                        and the planet. Our philosophy is built around three pillars:</p>
                    </div>

                    <div class="why-choose-one__more-btn-wrap d-none">
                        <a href="#" class="agrofa-btn why-choose-more--btn"><span>More Services</span></a>
                    </div>
                </div>

                <div class="row why-choose-one__row">
                    <div class="why-choose-one__col col-xl-4 wow fadeIn" data-wow-delay="800ms">
                        <div class="why-choose-one__bg">
                            <div class="why-choose-one__bg-inner">
                                <div class="why-choose-one__top">
                                    <div class="why-choose-one__icon-bx">
                                        <i class="icon-apple why-choose-one__icon"></i>
                                    </div>

                                    <div class="why-choose-one__top__right">
                                        <h6 class="why-choose-one__name">Purity</h6>
                                    </div>
                                </div>

                                <div class="why-choose-one__content">
                                    <p class="why-choose-one__descript">No chemicals, no additives, no shortcuts. Every product is processed with strict
                                    adherence to organic standards and hygiene protocols.</p>
                                    <!--<a href="#" class="why-choose-one__read-btn">Read More</a>-->
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="why-choose-one__col col-xl-4 wow fadeIn" data-wow-delay="900ms">
                        <div class="why-choose-one__bg">
                            <div class="why-choose-one__bg-inner">
                                <div class="why-choose-one__top">
                                    <div class="why-choose-one__icon-bx">
                                        <i class="icon-crop why-choose-one__icon"></i>
                                    </div>

                                    <div class="why-choose-one__top__right">
                                        <h6 class="why-choose-one__name">Partnerships</h6>
                                    </div>
                                </div>

                                <div class="why-choose-one__content">
                                    <p class="why-choose-one__descript">We believe in growing with our farmers, clients, and partners. Our long-
                                    term vision is to build a network of relationships rooted in mutual benefit, fairness, and reliability.</p>
                                    <!--<a href="#" class="why-choose-one__read-btn">Read More</a>-->
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="why-choose-one__col col-xl-4 wow fadeIn" data-wow-delay="1000ms">
                        <div class="why-choose-one__bg">
                            <div class="why-choose-one__bg-inner">
                                <div class="why-choose-one__top">
                                    <div class="why-choose-one__icon-bx">
                                        <i class="icon-medicine why-choose-one__icon"></i>
                                    </div>

                                    <div class="why-choose-one__top__right">
                                        <h6 class="why-choose-one__name">Purpose</h6>
                                    </div>
                                </div>

                                <div class="why-choose-one__content">
                                    <p class="why-choose-one__descript">Excellence EXIM is not just a business; it’s a mission. A mission to promote
                                    sustainable agriculture, to bring recognition to Indian farmers, and to offer global consumers access to authentic, 
                                    nutrient-rich organic produce.</p>
                                    <!--<a href="service-d-dairy-products.html" class="why-choose-one__read-btn">Read More</a>-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="why-choose-one__more-choose d-none">
                <div class="why-choose-one__more-choose--bg">
                    <h4 class="why-choose-one__more-choose--title">To Receive an Extraordinary Service, Call Us Today!</h4>
                    <div class="why-choose-one__more-choose--phone-number-wrap">
                        <i class="icon-phone why-choose-one__more-choose--phone-icon"></i>
                        <a href="tel:+8805002451" class="why-choose-one__more-choose--phone-number"><span>+88 05 00 24 51 </span></a>
                    </div>
                </div>
            </div>
        </section><!-- /.why-choose-one--three -->
        
        <section class="team-skills-one team-skills-one--three team-skills-one--about" id="product">
            <div class="container">
                <div class="section-common-title">
                    <span class="team-skills-one__chose-reasone food-chose-reasone fadeInLeft wow" data-wow-delay="200ms">
                        <img class="team-skills-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                        <strong class="team-skills-one__chose-name food-chose-name">Our Product</strong>
                    </span>
                    
                </div>

                <div class="row team-skills-one__row mt-5">
                    <div class="col-lg-6 order-2 order-md-1 align-self-center">
                        <div class="team-skills-one__left-content__inner">
                            <h4 class="team-skills-one__col-title">Organic Turmeric</h4>
                            <p class="team-skills-one__col-text text-justify">Our signature product, organic turmeric, stands out for its deep golden hue, earthy aroma, and
                            exceptionally high curcumin concentration. Grown on our own farm near Nagpur using
                            sustainable methods, it is free from any chemical residues. To ensure unmatched purity and
                            potency, our turmeric is lab-tested and certified by a renowned, NABL-accredited testing
                            laboratory. The results have consistently shown curcumin levels and microbial safety metrics
                            far exceeding international benchmarks, making it a trusted choice for health-conscious
                            consumers, supplement brands, and spice importers worldwide.</p>
                        </div>
                    </div>
                    <div class="col-lg-6 order-1 order-md-2">
                        <img src="assets/termuric.jpg" alt="" style="width:100%;height:100%">
                    </div>
                    <!--<div class="team-skills-one__col-left">-->
                    <!--    <div class="team-skills-one__left-content">-->
                    <!--        <div class="team-skills-one__left-content__inner">-->
                    <!--            <h4 class="team-skills-one__col-title">Organic Turmeric</h4>-->
                    <!--            <p class="team-skills-one__col-text">Our signature product, organic turmeric, stands out for its deep golden hue, earthy aroma, and-->
                    <!--            exceptionally high curcumin concentration. Grown on our own farm near Nagpur using-->
                    <!--            sustainable methods, it is free from any chemical residues. To ensure unmatched purity and-->
                    <!--            potency, our turmeric is lab-tested and certified by a renowned, NABL-accredited testing-->
                    <!--            laboratory. The results have consistently shown curcumin levels and microbial safety metrics-->
                    <!--            far exceeding international benchmarks, making it a trusted choice for health-conscious-->
                    <!--            consumers, supplement brands, and spice importers worldwide.</p>-->
                    <!--        </div>-->
                    <!--    </div>-->
                    <!--</div>-->
                    <!--<div class="team-skills-one__col-right">-->
                    <!--    <div class="team-skills-three__img">-->
                    <!--        <img src="assets/images/resources/skill-men3-1.jpg" alt="">-->
                    <!--    </div>-->
                    <!--</div>-->
                </div>
                <div class="row team-skills-one__row">
                    <div class="col-lg-6">
                        <img src="https://erikaorganics.com/cdn/shop/products/DSC04242_3_900x.jpg?v=1594577436" alt="" style="width:100%;height:100%">
                    </div>
                    <div class="col-lg-6 align-self-center">
                        <div class="team-skills-one__left-content__inner">
                            <h4 class="team-skills-one__col-title">Organic Moong Dal (Green Gram)</h4>
                            <p class="team-skills-one__col-text text-justify">We export premium moong dal, grown in nutrient-rich soil using eco-friendly farming methods.
                            Naturally low in fat and high in plant-based protein, it is a wholesome option for everyday
                            meals. Our moong dal is unpolished and free from synthetic processing, preserving its
                            nutritional value and natural taste.</p>
                        </div>
                    </div>
                </div>
                <div class="row team-skills-one__row">
                    <div class="col-lg-6 order-2 order-md-1 align-self-center">
                        <div class="team-skills-one__left-content__inner">
                            <h4 class="team-skills-one__col-title">Organic Toor Dal (Pigeon Pea)</h4>
                            <p class="team-skills-one__col-text text-justify">Sourced from certified organic farms, our toor dal is a key protein staple with a mild, nutty
                            flavor and smooth texture when cooked. It is carefully cleaned, sorted, and packaged to retain
                            its freshness and quality, making it ideal for retail and wholesale supply.</p>
                        </div>
                    </div>
                    <div class="col-lg-6 order-1 order-md-2">
                        <img src="assets/toor dal.jpg" alt="" style="width:100%;height:100%">
                    </div>
                </div>
                <div class="row team-skills-one__row">
                    <div class="col-lg-6">
                        <img src="https://5.imimg.com/data5/SELLER/Default/2025/1/478684136/HW/DL/UG/238846215/fresh-dry-ginger-500x500.jpeg" alt="" style="width:100%;height:100%">
                    </div>
                    <div class="col-lg-6 align-self-center">
                        <div class="team-skills-one__left-content__inner">
                            <h4 class="team-skills-one__col-title">Organic Ginger</h4>
                            <p class="team-skills-one__col-text text-justify">We offer fresh and dried organic ginger known for its bold flavor, aroma, and natural medicinal
                            properties. Grown without chemical inputs, our ginger is popular with food processors, herbal
                            manufacturers, and spice traders across global markets.</p>
                        </div>
                    </div>
                </div>
                
                <p class="team-skills-one__col-text text-justify">All our products go through rigorous quality assurance, including moisture, pesticide residue,
                and microbial testing — ensuring clean, safe, and export-ready goods for every shipment.</p>
               
            </div>
        </section><!-- /.team-skills-one--three -->
        
        <section class="food-one food-one--two d-none" id="infrastructure">
            <div class="container">
                <div class="row food-one__content-bx flex-row-reverse">
                    <div class="food-one__left fadeInRight wow animated align-self-center" data-wow-delay="300ms">
                        <div class="section-common-title">
                            <span class="food-one__chose-reasone food-chose-reasone">
                                <img class="food-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                <strong class="food-one__chose-name food-chose-name">Our Infrastructure</strong>
                            </span>
                            <!--<h2 class="food-one__title food-chose-title">Our Farm And Who We Are</h2>-->
                            <p class="food-one__text food-chose-text">Our farm and processing facility are located near Nagpur, one of the fastest-growing export
                            hubs in central India. The location offers excellent connectivity for shipping and logistics,
                            ensuring that our products reach ports swiftly and efficiently. The turmeric cultivated on our
                            farm is processed using state-of-the-art, food-grade machinery, designed to retain the
                            product’s natural aroma, color, and curcumin content.</p>
                            <p class="food-one__text food-chose-text">We also follow stringent quality control practices, including lab testing for purity, moisture
                            content, and microbial safety. This commitment to excellence ensures that every shipment we
                            deliver is consistent, clean, and ready to meet the demands of international markets.</p>
                        </div>

                        
                    </div>

                    <div class="food-one__right fadeInLeft wow animated" data-wow-delay="300ms">
                        <div class="food-one__right-img">
                            <img src="assets/images/resources/food-men3-1.png" alt="">
                        </div>
                        <div class="food-one__bottom-img">
                            <img src="assets/images/resources/food-men3-2.png" alt="">
                        </div>
                    </div>
                </div>
            </div>

            <div class="food-one--two__effect-left">
                <img src="assets/images/shapes/food-shape3-2.png" alt="">
            </div>
            <div class="food-one--two__effect-right">
                <img src="assets/images/shapes/food-shape3-1.png" alt="">
            </div>
        </section> <!-- /.food-one--two -->
        
        
        <section class="team-skills-one team-skills-one--two d-none">
            <div class="container-fluid">
                <div class="row team-skills-one__row">
                    <div class="team-skills-one__col-left">
                        <div class="team-skills-one__left-content">
                            <div class="team-skills-one__left-content__inner">
                                <div class="section-common-title">
                                    <span class="team-skills-one__chose-reasone food-chose-reasone fadeInLeft wow" data-wow-delay="1200ms">
                                        <img class="team-skills-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                        <strong class="team-skills-one__chose-name food-chose-name">Our Commitment to Sustainability</strong>
                                    </span>
                                    <p class="team-skills-one__col-text">Sustainability is not a marketing buzzword for us — it’s at the core of our business model. We
                                    follow organic farming practices that minimize environmental impact, conserve water, and
                                    promote biodiversity. We avoid chemical fertilizers and pesticides, instead relying on traditional
                                    composting, crop rotation, and natural pest control methods.</p>
                                    <p class="team-skills-one__col-text">Beyond the farm, we use eco-friendly packaging, support local employment, and work towards
                                    empowering women in agriculture through training and fair wages. Our long-term aim is to
                                    establish fully traceable farm-to-fork supply chains, where every product can be tracked back
                                    to its origin.</p>
                                </div>
                                <div class="section-common-title">
                                    <span class="team-skills-one__chose-reasone food-chose-reasone fadeInLeft wow" data-wow-delay="1200ms">
                                        <img class="team-skills-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                        <strong class="team-skills-one__chose-name food-chose-name">Global Vision, Local Roots</strong>
                                    </span>
                                    <p class="team-skills-one__col-text">Although we are based in India, our vision is decidedly global. We understand the complexities
                                    of international trade — from documentation and certifications to shipping and regulatory compliance — and are fully equipped to cater 
                                    to markets across the Middle East, Europe, North America, and Southeast Asia.</p>
                                    <p class="team-skills-one__col-text">But no matter how far we reach, we never lose sight of our roots. Our identity is shaped by our
                                    land, our farmers, and our culture — and every transaction we make is a reflection of that deep-rooted identity.</p>
                                </div>

                                
                            </div>
                        </div>
                    </div>
                    <div class="team-skills-one__col-right d-none">
                        <div class="team-skills-one__col-right__all-product">
                            <div class="team-skills-one__col-right__bg text-center">
                                <h4 class="team-skills-one__col-right__count-product">3145+</h4>
                                <h5 class="team-skills-one__col-right__pure-product">Pure Organic
                                    Products </h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="team-skills-one__right-image">
                <div class="team-skills-one__right-image__bg">
                    <img src="assets/images/resources/happy-customer2-1.png" alt="">
                </div>
            </div>
        </section><!-- /.team-skills-one--two -->

        
        <section class="why-choose-one">
            <div class="container">
                <div class="section-common-title fadeInDown wow" data-wow-delay="200ms">
                    <span class="why-choose-one__chose-reasone food-chose-reasone">
                        <img class="why-choose-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                        <strong class="why-choose-one__chose-name food-chose-name">Why Choose Excellence EXIM?</strong> 
                    </span>
                    <!--<h2 class="why-choose-one__title food-chose-title">We Offers Agriculture Eco Services</h2>-->
                </div>

                <div class="row why-choose-one__row justify-content-center mt-4">
                    <div class="why-choose-one__col col-xl-3 col-12 wow fadeIn" data-wow-delay="100ms">
                        <div class="why-choose-one__bg">
                            <div class="why-choose-one__bg-inner">
                                <div class="why-choose-one__top">
                                    <div class="why-choose-one__icon-bx">
                                        <i class="icon-apple why-choose-one__icon"></i>
                                    </div>

                                    <div class="why-choose-one__top__right">
                                        <h6 class="why-choose-one__name">Founder-led commitment:</h6>
                                    </div>
                                </div>

                                <div class="why-choose-one__content">
                                    <p class="why-choose-one__descript">As a family-run business, every detail matters to us personally.</p>
                                    <!--<a href="#" class="why-choose-one__read-btn">Read More</a>-->
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="why-choose-one__col col-xl-3 wow fadeIn" data-wow-delay="200ms">
                        <div class="why-choose-one__bg">
                            <div class="why-choose-one__bg-inner">
                                <div class="why-choose-one__top">
                                    <div class="why-choose-one__icon-bx">
                                        <i class="icon-crop why-choose-one__icon"></i>
                                    </div>

                                    <div class="why-choose-one__top__right">
                                        <h6 class="why-choose-one__name">Full traceability:</h6>
                                    </div>
                                </div>

                                <div class="why-choose-one__content">
                                    <p class="why-choose-one__descript">From our farm to your shelf, we offer complete transparency.</p>
                                    <!--<a href="#" class="why-choose-one__read-btn">Read More</a>-->
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="why-choose-one__col col-xl-3 wow fadeIn" data-wow-delay="300ms">
                        <div class="why-choose-one__bg">
                            <div class="why-choose-one__bg-inner">
                                <div class="why-choose-one__top">
                                    <div class="why-choose-one__icon-bx">
                                        <i class="icon-medicine why-choose-one__icon"></i>
                                    </div>

                                    <div class="why-choose-one__top__right">
                                        <h6 class="why-choose-one__name">Certified organic quality</h6>
                                    </div>
                                </div>

                                <div class="why-choose-one__content">
                                    <p class="why-choose-one__descript">All our products adhere to Indian and international organic standards.</p>
                                    <!--<a href="service-d-dairy-products.html" class="why-choose-one__read-btn">Read More</a>-->
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="why-choose-one__col col-xl-3 wow fadeIn" data-wow-delay="400ms">
                        <div class="why-choose-one__bg">
                            <div class="why-choose-one__bg-inner">
                                <div class="why-choose-one__top">
                                    <div class="why-choose-one__icon-bx">
                                        <i class="icon-crops why-choose-one__icon"></i>
                                    </div>

                                    <div class="why-choose-one__top__right">
                                        <h6 class="why-choose-one__name">Custom packaging solutions:</h6>
                                    </div>
                                </div>

                                <div class="why-choose-one__content">
                                    <p class="why-choose-one__descript">We offer bulk, retail, and white-label packaging based on client needs.</p>
                                    <!--<a href="#" class="why-choose-one__read-btn">Read More</a>-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="why-choose-one__col col-xl-3 wow fadeIn" data-wow-delay="400ms">
                        <div class="why-choose-one__bg">
                            <div class="why-choose-one__bg-inner">
                                <div class="why-choose-one__top">
                                    <div class="why-choose-one__icon-bx">
                                        <i class="icon-crops why-choose-one__icon"></i>
                                    </div>

                                    <div class="why-choose-one__top__right">
                                        <h6 class="why-choose-one__name">Reliable supply chain:</h6>
                                    </div>
                                </div>

                                <div class="why-choose-one__content">
                                    <p class="why-choose-one__descript">On-time delivery and strong logistics partnerships for seamless trade..</p>
                                    <!--<a href="#" class="why-choose-one__read-btn">Read More</a>-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="why-choose-one__more-choose d-none">
                <div class="why-choose-one__more-choose--bg">
                    <h4 class="why-choose-one__more-choose--title">We are Distributors of Quality 100% <br> Organic Herbs and Produce.</h4>
                    <div class="why-choose-one__more-choose--btn">
                        <a href="#" class="agrofa-btn why-choose-more--btn"><span>More Services</span></a>
                    </div>
                </div>
            </div>
        </section><!-- /.why-choose-one -->
        
        

       

        
        
        
        <section class="latest-work-one mt-5" id="gallery">
            <div class="container-fluid">
                <div class="section-common-title">
                    <span class="latest-work-one__chose-reasone food-chose-reasone fadeInLeft wow" data-wow-delay="200ms">
                        <img class="latest-work-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                        <strong class="latest-work-one__chose-name food-chose-name">Project Gallerys</strong>
                    </span>
                    <!--<h2 class="latest-work-one__title food-chose-title fadeInLeft wow" data-wow-delay="200ms">Latest From Our Work</h2>-->
                    <p class="team-skills-one__col-text">At Excellence EXIM, we offer a premium selection of certified organic agricultural products,
                    grown with integrity and care. Each item in our portfolio is cultivated using natural, chemical-
                    free practices and is carefully processed to meet global standards of quality and safety.</p>
                </div>

                <div class="row latest-work-one__bx">
                    <div class="row latest-work-one__carousel agrofa-owl__carousel agrofa-owl__carousel--with-shadow agrofa-owl__carousel--basic-nav owl-carousel" data-owl-options='{
				"items": 1,
				"margin": 0,
				"loop": false,
				"smartSpeed": 700,
				"nav": false,
				"navText": [""],
				"dots": false,
				"autoplay": false,
				"responsive": {
					"0": {
						"items": 1,
						"dots": true
					},
					"992": {
						"items": 2,
						"margin": 30,
						"dots": false
					},
					"1200": {
						"items": 3,
						"margin": 30,
						"dots": false
					},
					"1440": {
						"items": 4,
						"margin": 30,
						"dots": false
					}
				}
			}'>
                        <div class="item">
                            <div class="latest-work-one__col">
                                <div class="latest-work-one__inner">
                                    <div class="latest-work-one__img">
                                        <div class="latest-work-one__inner-img"><img src="assets/img/chola.jpeg" alt=""></div> 
                                        <div class="latest-work-one__btm-info d-none">
                                            <h5 class="latest-work-one__work-title">Organic food</h5>
                                            <a href="#" class="agrofa-btn latest-work--btn">
                                                <span>More</span>
                                                <i class="icon-right-arrow latest-work-btn--arrow"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="item">
                            <div class="latest-work-one__col">
                                <div class="latest-work-one__inner">
                                    <div class="latest-work-one__img">
                                        <div class="latest-work-one__inner-img"><img src="assets/img/daal.jpeg" alt=""></div>
                                        <div class="latest-work-one__btm-info d-none">
                                            <h5 class="latest-work-one__work-title">Agriculture Products</h5>
                                            <a href="#" class="agrofa-btn latest-work--btn">
                                                <span>More</span>
                                                <i class="icon-right-arrow latest-work-btn--arrow"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!--<div class="item">-->
                        <!--    <div class="latest-work-one__col">-->
                        <!--        <div class="latest-work-one__inner">-->
                        <!--            <div class="latest-work-one__img">-->
                        <!--                <div class="latest-work-one__inner-img"><img src="assets/img/tumeric powder.jpeg" alt=""></div>-->
                        <!--                <div class="latest-work-one__btm-info d-none">-->
                        <!--                    <h5 class="latest-work-one__work-title">Lemon Thyme</h5>-->
                        <!--                    <a href="#" class="agrofa-btn latest-work--btn">-->
                        <!--                        <span>More</span>-->
                        <!--                        <i class="icon-right-arrow latest-work-btn--arrow"></i>-->
                        <!--                    </a>-->
                        <!--                </div>-->
                        <!--            </div>-->
                        <!--        </div>-->
                        <!--    </div>-->
                        <!--</div>-->

                        <div class="item">
                            <div class="latest-work-one__col">
                                <div class="latest-work-one__inner">
                                    <div class="latest-work-one__img">
                                        <div class="latest-work-one__inner-img"><img src="assets/img/chana.jpeg" alt=""></div>
                                        <div class="latest-work-one__btm-info d-none">
                                            <h5 class="latest-work-one__work-title">Fresh food firm</h5>
                                            <a href="#" class="agrofa-btn latest-work--btn">
                                                <span>More</span>
                                                <i class="icon-right-arrow latest-work-btn--arrow"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        

                        
                    </div>
                </div>

                <div class="latest-work-one__more-work d-none">
                    <div class="latest-work-one__more-inner-bg">
                        <h6 class="latest-work-one__more-work-title">Need help converting to organic or farming more sustainably?</h6>
                        <a href="#" class="agrofa-btn more-work--btn"><span>View More Work</span></a>
                    </div>
                </div>
            </div>
        </section><!-- /.latest-work-one -->
        
        

       
        <section class="get-touch-one get-touch-one--farmer_gettouch" id="contact">
            <div class="container">
                <div class="row get-touch-one__row">
                    <div class="get-touch-one__form col-md-6 col-sm-12">
                        <form id="contact-form" action="mailcontact.php" method="POST" class="contact-form-validated">
                            <div class="get-touch-one__form-row w-100">
                                <div class="get-touch-one__form-group col-sm-12">
                                    <input type="text" name="name" class="get-touch-one__field" placeholder="Your Name">
                                    <div class="get-touch-one__field-bd-effect"></div>
                                </div>
                                <div class="get-touch-one__form-group col-sm-12">
                                    <input type="email" name="email" class="get-touch-one__field" placeholder="Eamil Address">
                                    <div class="get-touch-one__field-bd-effect"></div>
                                </div>
                                <div class="get-touch-one__form-group col-sm-12">
                                    <input type="number" name="phone" class="get-touch-one__field" placeholder="Your Phone Number">
                                    <div class="get-touch-one__field-bd-effect"></div>
                                </div>
                                <div class="get-touch-one__form-group col-sm-12">
                                    <input type="text" name="subject" class="get-touch-one__field" placeholder="Your Subject">
                                    <div class="get-touch-one__field-bd-effect"></div>
                                </div>
                                <div class="get-touch-one__form-group col-sm-12">
                                    <textarea name="message" class="get-touch-one__field textarea--field" placeholder="Message"></textarea>
                                    <div class="get-touch-one__field-bd-effect"></div>
                                </div>

                                <div class="form-submit-btn-wrap">
                                    <button class="form-submit-btn" type="submit">Send A Message</button>
                                </div>
                            </div>
                        </form>
                        <div class="contactresult"></div>
                    </div>

                    <div class="get-touch-one__content col-md-6 col-sm-12">
                        <div class="section-common-title fadeInDown wow animated" data-wow-delay="1500ms">
                            <span class="get-touch-one__chose-reasone food-chose-reasone">
                                <img class="get-touch-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                <strong class="get-touch-one__chose-name food-chose-name">Get In Touch</strong>
                            </span>
                            <h2 class="get-touch-one__title food-chose-title">Reach Us Send A Message</h2>
                            <p class="get-touch-one__text food-chose-text fadeInRight wow animated" data-wow-delay="1200ms">We’d love to connect with you. Whether you&#39;re looking for product information, export
                            queries, or business collaborations — the team at Excellence EXIM is always ready to assist.</p>

                            <ul class="list-unstyled get-touch-one__contact-info">
                                <li class="get-touch-one__info__contact-item">
                                    <i class="icon-phone get-touch-one__contact__icon"></i>
                                    <div class="get-touch-one__contact-support">
                                        <small class="get-touch-one__contact--text">Helpline and Support</small>
                                        <a href="tel:8237409122">+91-8237409122</a>
                                    </div>
                                </li>
                                <li class="get-touch-one__info__contact-item">
                                    <i class="icon-location get-touch-one__contact__icon"></i>
                                    <div class="get-touch-one__contact-support">
                                        <small class="get-touch-one__contact--text">Our Address</small>
                                        <a href="#">Plot No. 188, Savarbandhe Layout Hudkeshwar Road, Nagpur Maharashtra – 440034, India</a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="opening ">
            <div class="container">
                <div class="opening__wrapper">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="opening__info-row text-center">
                                <div class="opening__info-row__icon"><i class="icon-phone"></i></div>
                                <div class="opening__info-row__content">
                                    <span class="opening__info-row__support-text">Helpline and Support</span>
                                    <p class="opening__info-row__support-number"><a href="tel:8237409122">+91-8237409122</a></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="opening__info-row text-center">
                                <div class="opening__info-row__icon"><i class="icon-location"></i></div>
                                <div class="opening__info-row__content">
                                    <span class="opening__info-row__support-text">Our Address</span>
                                    <p class="opening__info-row__support-number">Plot No. 188,
                                        Savarbandhe Layout
                                        Hudkeshwar Road,
                                        Nagpur
                                        Maharashtra – 440034, India</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="opening__info-row text-center">
                                <div class="opening__info-row__icon"><i class="icon-email"></i></div>
                                <div class="opening__info-row__content">
                                    <span class="opening__info-row__support-text">Send an Email</span>
                                    <p class="opening__info-row__support-number"><a href="mailto:office.excellenceexim@gmail.com">office.excellenceexim@gmail.com</a></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- /.container -->
        </section><!-- /.opening -->
        
        <?php include 'include/footer.php' ?>
        <!-- /.main-footer -->

    </div><!-- /.page-wrapper -->



    <?php include 'include/mobile-menu.php' ?>

    <a href="#" data-target="html" class="scroll-to-target scroll-to-top">
        <span class="scroll-to-top__text">back top</span>
        <span class="scroll-to-top__wrapper"><span class="scroll-to-top__inner"></span></span>
    </a>


   <?php include 'include/footerjs.php' ?>
</body>


</html>