<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About - Excellence EXIM </title>
    <!-- favicons Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="assets/images/favicons/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/images/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/images/favicons/favicon-16x16.png">
    <link rel="manifest" href="assets/images/favicons/site.webmanifest">
    <?php include 'include/head.php' ?>
</head>

<body class="custom-cursor">

    <div class="custom-cursor__cursor"></div>
    <div class="custom-cursor__cursor-two"></div>

    <div class="preloader">
        <div class="preloader__image" style="background-image: url(assets/images/loader.png);"></div>
    </div>
    <!-- /.preloader -->
    <div class="page-wrapper">
        <!--?php include 'include/top.php' ?--> 

        <?php include 'include/header.php' ?>
        <!-- /.main-header -->
        <!-- main-slider-start -->
        <section class="page-header page-header--projects-two">
            <div class="page-header__bg"></div>
            <!-- /.page-header__bg -->
            <div class="container">
                <!-- <img src="assets/images/shapes/page-header-s-1.png" alt="Projects" class="page-header__shape"> -->
                <h2 class="page-header__title">About Us</h2>
                <ul class="agrofa-breadcrumb list-unstyled">
                    <li><a href="index.php">Home</a></li>
                    <li><span>About Us</span></li>
                </ul><!-- /.thm-breadcrumb list-unstyled -->
            </div><!-- /.container -->
        </section><!-- /.page-header -->
        
        
        <section class="about-two" id="about">
            <div class="container-fluid">
                <div class="row about-two__content-row">
                    <div class="about-two__left fadeInLeft wow" data-wow-delay="1500ms">
                        <div class="about-two__left__all-product">
                            <div class="about-two__left__bg text-center">
                                <h4 class="about-two__left__count-product">100%</h4>
                                <h5 class="about-two__left__pure-product"> Satisfaction
                                    guarantee</h5>
                            </div>
                        </div>
                    </div>

                    <div class="about-two__right fadeInRight wow align-self-center" data-wow-delay="1500ms">
                        <div class="section-common-title">
                            <span class="about-two__chose-reasone food-chose-reasone">
                                <img class="about-two__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                <strong class="about-two__chose-name food-chose-name">About our Compnay</strong>
                            </span>
                            <!--<h2 class="about-two__title food-chose-title">Providing the Organic service </h2>-->
                            <p class="about-two__text food-chose-text">At Excellence EXIM, we believe that excellence is not just in our name — it's in everything we do. 
                            Founded in March 2023 by the husband-wife duo Mr. Umesh Birole and Mrs. Rupali Birole, our company was born from a shared vision: 
                            to bring the rich, authentic, and organic agricultural produce of India to the global market. With a primary focus on organic turmeric, 
                            we aim to redefine the standards of purity, quality, and sustainability in global spice trade.</p>
                            <p class="about-two__text food-chose-text">We are a family-run business rooted in values of integrity, trust, and long-term relationships. 
                            What sets us apart is not just what we export, but how we do it — with full control over the quality and cultivation practices of our 
                            flagship product: organic turmeric grown and processed at our very own farm, located just 70 kilometers from Nagpur, Maharashtra. 
                            Every batch that leaves our facility carries with it a story of care, tradition, and science-backed agriculture.</p>
                        </div>

                        <div class="about-two__featurebx d-none">
                            <div class="about-two__col">
                                <div class="about-two__cricle">
                                    <i class="icon-medal about-two__icon" aria-hidden="true"></i>
                                </div>
                                <div class="about-two__quality-info-bx">
                                    <h6 class="about-two__quality-title">100% Guaranteed Organic</h6>
                                    <p class="about-two__quality-info">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore </p>
                                </div>
                            </div>
                            <div class="about-two__col">
                                <div class="about-two__cricle">
                                    <i class="icon-crops about-two__icon" aria-hidden="true"></i>
                                </div>
                                <div class="about-two__quality-info-bx">
                                    <h6 class="about-two__quality-title">Top-Quality Healthy Foods</h6>
                                    <p class="about-two__quality-info">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore </p>
                                </div>
                            </div>
                        </div>
                        <ul class="about-two__quality-list d-none">
                            <li><i class="fas fa-check-circle"></i> Need help converting to organic or farming more sustainably?</li>
                            <li><i class="fas fa-check-circle"></i> Fresh, reliable, sustainable ingredients for the food industry</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="about-two__effect-bg">
                <img src="assets/images/resources/about-photo2-1.png" alt="">
            </div>
        </section>
        
        <section class="food-one" id="origins">
            <div class="container">
                <div class="row food-one__content-bx">
                    <div class="food-one__left fadeInLeft wow align-self-center" data-wow-delay="200ms">
                        <div class="section-common-title">
                            <span class="food-one__chose-reasone food-chose-reasone">
                                <img class="food-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                <strong class="food-one__chose-name food-chose-name">Our Origins</strong>
                            </span>
                            <!--<h2 class="food-one__title food-chose-title">Get Food Without Preservatives.</h2>-->
                            <p class="food-one__text food-chose-text">Excellence EXIM was established with a simple yet powerful purpose: 
                            to make India’s organic produce more accessible to international markets while supporting sustainable farming and empowering 
                            rural communities. Coming from a background with a deep connection to the land, Mr.Umesh and Mrs.Rupali Birole understood early 
                            on the immense potential of organic farming — not just as a business model, but as a movement that contributes to healthier living, 
                            safer food chains, and a more balanced ecosystem.</p>
                            <p class="food-one__text food-chose-text">From the beginning, the goal was not volume, but value. Rather than becoming just another exporter, 
                            we chose to specialize in products we deeply understand, ensuring that every shipment carries our signature of transparency, 
                            traceability, and trust.</p>
                        </div>

                        <div class="food-one__featurebx d-none">
                            <div class="food-one__col">
                                <div class="food-one__cricle">
                                    <i class="icon-medal food-one__icon" aria-hidden="true"></i>
                                </div>
                                <div class="food-one__quality-info-bx">
                                    <h6 class="food-one__quality-title">100% Guaranteed Organic</h6>
                                    <p class="food-one__quality-info">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore </p>
                                </div>
                            </div>

                            <div class="food-one__col">
                                <div class="food-one__cricle">
                                    <i class="icon-crops food-one__icon" aria-hidden="true"></i>
                                </div>
                                <div class="food-one__quality-info-bx">
                                    <h6 class="food-one__quality-title">Top-Quality Healthy Foods</h6>
                                    <p class="food-one__quality-info">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="food-one__right fadeInRight wow" data-wow-delay="200ms">
                        <div class="food-one__right-img">
                            <img src="assets/images/resources/food-men1-1.png" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </section><!-- /.food-one -->
        
        <section class="food-one food-one--two" id="what_we_do">
            <div class="container">
                <div class="row food-one__content-bx flex-row-reverse">
                    <div class="food-one__left fadeInRight wow animated align-self-center" data-wow-delay="300ms">
                        <div class="section-common-title">
                            <span class="food-one__chose-reasone food-chose-reasone">
                                <img class="food-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                <strong class="food-one__chose-name food-chose-name">What We Do</strong>
                            </span>
                            <!--<h2 class="food-one__title food-chose-title">Our Farm And Who We Are</h2>-->
                            <p class="food-one__text food-chose-text">At the heart of Excellence EXIM lies our organic turmeric, cultivated using natural and regenerative 
                            farming practices that restore soil health, avoid chemical inputs, and ensure maximum potency of curcumin — the active ingredient known for its 
                            medicinal and culinary benefits. Our farm near Nagpur enjoys ideal agro-climatic conditions for turmeric cultivation, and we manage every stage 
                            of the process — from sowing and harvesting to drying, grinding, and packaging.</p>
                            <p class="food-one__text food-chose-text">We are not limited to turmeric alone. As we grow, our portfolio of organic spices and agricultural products will expand to include other natural 
                            exports such as ginger, moong dal, and select pulses and grains — all sourced ethically from certified organic farms across India.</p>
                        </div>

                        <div class="food-one__feature--wrap d-flex flex-wrap d-none">
                            <div class="food-one__feature--wrap__col">
                                <div class="food-one__feature--wrap__bg yellow--bg">
                                    <i class="icon-medal"></i>
                                    <h6 class="food-one__feature--wrap__title">100% Guaranteed <br> Organic farm</h6>
                                </div>
                            </div>

                            <div class="food-one__feature--wrap__col">
                                <div class="food-one__feature--wrap__bg green--bg">
                                    <i class="icon-farmer"></i>
                                    <h6 class="food-one__feature--wrap__title">Professional <br> Farmers</h6>
                                </div>
                            </div>
                        </div>
                        <ul class="food-one__quality-list d-none">
                            <li><i class="icon-cda67021ce37b3d91d9f660e16bda341"></i> Adipisci velit sed quia non numquam eius modi tempora </li>
                            <li><i class="icon-cda67021ce37b3d91d9f660e16bda341"></i> Providing High Quality Products many variations of passages of lorem</li>
                        </ul>
                    </div>

                    <div class="food-one__right fadeInLeft wow animated" data-wow-delay="300ms">
                        <div class="food-one__right-img">
                            <img src="assets/images/resources/food-men3-1.png" alt="">
                        </div>
                        <div class="food-one__bottom-img">
                            <img src="assets/images/resources/food-men3-2.png" alt="">
                        </div>
                    </div>
                </div>
            </div>

            <div class="food-one--two__effect-left">
                <img src="assets/images/shapes/food-shape3-2.png" alt="">
            </div>
            <div class="food-one--two__effect-right">
                <img src="assets/images/shapes/food-shape3-1.png" alt="">
            </div>
        </section> <!-- /.food-one--two -->
        
        
        <section class="food-one food-one--two" id="infrastructure">
            <div class="container">
                <div class="row food-one__content-bx flex-row-reverse">
                    <div class="food-one__left fadeInRight wow animated align-self-center" data-wow-delay="300ms">
                        <div class="section-common-title">
                            <span class="food-one__chose-reasone food-chose-reasone">
                                <img class="food-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                <strong class="food-one__chose-name food-chose-name">Our Infrastructure</strong>
                            </span>
                            <!--<h2 class="food-one__title food-chose-title">Our Farm And Who We Are</h2>-->
                            <p class="food-one__text food-chose-text">Our farm and processing facility are located near Nagpur, one of the fastest-growing export
                            hubs in central India. The location offers excellent connectivity for shipping and logistics,
                            ensuring that our products reach ports swiftly and efficiently. The turmeric cultivated on our
                            farm is processed using state-of-the-art, food-grade machinery, designed to retain the
                            product’s natural aroma, color, and curcumin content.</p>
                            <p class="food-one__text food-chose-text">We also follow stringent quality control practices, including lab testing for purity, moisture
                            content, and microbial safety. This commitment to excellence ensures that every shipment we
                            deliver is consistent, clean, and ready to meet the demands of international markets.</p>
                        </div>

                        
                    </div>

                    <div class="food-one__right fadeInLeft wow animated" data-wow-delay="300ms">
                        <div class="food-one__right-img">
                            <img src="assets/images/resources/food-men3-1.png" alt="">
                        </div>
                        <div class="food-one__bottom-img">
                            <img src="assets/images/resources/food-men3-2.png" alt="">
                        </div>
                    </div>
                </div>
            </div>

            <div class="food-one--two__effect-left">
                <img src="assets/images/shapes/food-shape3-2.png" alt="">
            </div>
            <div class="food-one--two__effect-right">
                <img src="assets/images/shapes/food-shape3-1.png" alt="">
            </div>
        </section> <!-- /.food-one--two -->
        
        <section class="team-skills-one team-skills-one--two">
            <div class="container-fluid">
                <div class="row team-skills-one__row">
                    <div class="team-skills-one__col-left">
                        <div class="team-skills-one__left-content">
                            <div class="team-skills-one__left-content__inner">
                                <div class="section-common-title">
                                    <span class="team-skills-one__chose-reasone food-chose-reasone fadeInLeft wow" data-wow-delay="1200ms">
                                        <img class="team-skills-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                        <strong class="team-skills-one__chose-name food-chose-name">Our Commitment to Sustainability</strong>
                                    </span>
                                    <p class="team-skills-one__col-text">Sustainability is not a marketing buzzword for us — it’s at the core of our business model. We
                                    follow organic farming practices that minimize environmental impact, conserve water, and
                                    promote biodiversity. We avoid chemical fertilizers and pesticides, instead relying on traditional
                                    composting, crop rotation, and natural pest control methods.</p>
                                    <p class="team-skills-one__col-text">Beyond the farm, we use eco-friendly packaging, support local employment, and work towards
                                    empowering women in agriculture through training and fair wages. Our long-term aim is to
                                    establish fully traceable farm-to-fork supply chains, where every product can be tracked back
                                    to its origin.</p>
                                </div>
                                <div class="section-common-title">
                                    <span class="team-skills-one__chose-reasone food-chose-reasone fadeInLeft wow" data-wow-delay="1200ms">
                                        <img class="team-skills-one__chose-icon food-chose-icon" src="assets/images/shapes/food-img1-1.png" alt="">
                                        <strong class="team-skills-one__chose-name food-chose-name">Global Vision, Local Roots</strong>
                                    </span>
                                    <p class="team-skills-one__col-text">Although we are based in India, our vision is decidedly global. We understand the complexities
                                    of international trade — from documentation and certifications to shipping and regulatory compliance — and are fully equipped to cater 
                                    to markets across the Middle East, Europe, North America, and Southeast Asia.</p>
                                    <p class="team-skills-one__col-text">But no matter how far we reach, we never lose sight of our roots. Our identity is shaped by our
                                    land, our farmers, and our culture — and every transaction we make is a reflection of that deep-rooted identity.</p>
                                </div>

                                
                            </div>
                        </div>
                    </div>
                    <div class="team-skills-one__col-right d-none">
                        <div class="team-skills-one__col-right__all-product">
                            <div class="team-skills-one__col-right__bg text-center">
                                <h4 class="team-skills-one__col-right__count-product">3145+</h4>
                                <h5 class="team-skills-one__col-right__pure-product">Pure Organic
                                    Products </h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="team-skills-one__right-image">
                <div class="team-skills-one__right-image__bg">
                    <img src="assets/images/resources/happy-customer2-1.png" alt="">
                </div>
            </div>
        </section><!-- /.team-skills-one--two -->
        
        <?php include 'include/footer.php' ?>
        <!-- /.main-footer -->

    </div><!-- /.page-wrapper -->



    <?php include 'include/mobile-menu.php' ?>

    <a href="#" data-target="html" class="scroll-to-target scroll-to-top">
        <span class="scroll-to-top__text">back top</span>
        <span class="scroll-to-top__wrapper"><span class="scroll-to-top__inner"></span></span>
    </a>


   <?php include 'include/footerjs.php' ?>
</body>


</html>